<?php

class Parameters extends CApplicationComponent
{
	/**
	 * @var string the name of a database table, where settings are stored. Defaults to 'Setting'.
	 * This is used by {@link loadSettings}.
	 */
	public $tableName = 'ParametryGry';
	public $nameName  = 'nazwa';
	public $valueName = 'wartosc';

	/**
	 * @var integer the number of seconds in which the cached settings will expire. 0 means no caching.
	 * This is used by {@link loadSettings}.
	 */
	public $cacheTime = 0;

	protected $_settings = array();
	protected $_loaded = false;

	/**
	 * PHP magic method.
	 * This method is overriden so that settings can be accessed like properties.
	 * @param string $name property name
	 * @param mixed $value property value
	 */
	public function __get($name)
	{
		if($this->hasSetting($name))
			return $this->getSetting($name);
		else
			return parent::__get($name);
	}

	/**
	 * PHP magic method.
	 * This method is overriden so that settings can be set like properties.
	 * @param string $name property name
	 * @param mixed $value property value
	 */
	public function __set($name, $value)
	{
		if($this->hasSetting($name))
			$this->setSetting($name, $value);
		else
			parent::__set($name, $value);
	}

	/**
	 * Returns a value indicating whether there is a setting of the specified name.
	 * @param string $name setting name
	 * @return boolean whether there is a setting of the specified name
	 */
	public function hasSetting($name)
	{
		if(!$this->_loaded)
			$this->loadSettings();

		return isset($this->_settings[$name]) || array_key_exists($name, $this->_settings);
	}

	/**
	 * Returns the value of a setting.
	 * @param string $name setting name
	 * @return string the value of the setting. If it doesn't exist, null will be returned
	 * @see setState
	 */
	public function getSetting($name)
	{
		if(!$this->_loaded)
			$this->loadSettings();

		return isset($this->_settings[$name]) || array_key_exists($name, $this->_settings) ? $this->_settings[$name] : null;
	}

	/**
	 * Sets and stores a setting in database.
	 * @param string $name setting name
	 * @param string $value setting value
	 * @see getState
	 */
	public function setSetting($name, $value)
	{
		if(!$this->_loaded)
			$this->loadSettings();

		if($this->hasSetting($name))
		{
			$this->_settings[$name] = $value;
			Yii::app()->db->createCommand('UPDATE '.$this->tableName.' SET '.$this->valueName.' = "'.$value.'" WHERE '.$this->nameName.' = "'.$name.'"')->execute();
		}
	}

	/**
	 * Returns all settings.
	 * @return array settings as name => value pairs
	 */
	public function getAll()
	{
		if(!$this->_loaded)
			$this->loadSettings();

		return $this->_settings;
	}

	/**
	 * Loads settings from a database or cache if available.
	 */
	protected function loadSettings()
	{
		if($this->cacheTime < 1 || ($this->_settings = Yii::app()->cache->get('applicationSettings')) === false)
		{
			$rawSettings = Yii::app()->db->createCommand('SELECT '.$this->nameName.', '.$this->valueName.' FROM '.$this->tableName)->queryAll();

			$this->_settings = array();

			foreach($rawSettings as $setting)
				$this->_settings[$setting[$this->nameName]] = $setting[$this->valueName];

			if($this->cacheTime > 0)
				Yii::app()->cache->set('applicationSettings', $this->_settings, $this->cacheTime);

			$this->_loaded = true;
		}
	}
}
